/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Preconditions;
import org.python.google.common.util.concurrent.AbstractCheckedFuture;
import org.python.google.common.util.concurrent.AbstractListenableFuture;
import org.python.google.common.util.concurrent.CheckedFuture;
import org.python.google.common.util.concurrent.ExecutionList;
import org.python.google.common.util.concurrent.ForwardingFuture;
import org.python.google.common.util.concurrent.ListenableFuture;
import org.python.google.common.util.concurrent.MoreExecutors;
import org.python.google.common.util.concurrent.UninterruptibleFuture;
import org.python.google.common.util.concurrent.ValueFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Futures {
    private Futures() {
    }

    public static <V> UninterruptibleFuture<V> makeUninterruptible(final Future<V> future) {
        Preconditions.checkNotNull(future);
        if (future instanceof UninterruptibleFuture) {
            return (UninterruptibleFuture)future;
        }
        return new UninterruptibleFuture<V>(){

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public V get(long l, TimeUnit timeUnit) throws TimeoutException, ExecutionException {
                boolean bl = false;
                try {
                    long l2 = timeUnit.toNanos(l);
                    long l3 = System.nanoTime() + l2;
                    while (true) {
                        Object v;
                        try {
                            v = future.get(l2, TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            l2 = l3 - System.nanoTime();
                            bl = true;
                            continue;
                        }
                        return v;
                    }
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public V get() throws ExecutionException {
                boolean bl = false;
                while (true) {
                    try {
                        Object v = future.get();
                        return v;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    public static <V> ListenableFuture<V> makeListenable(Future<V> future) {
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future);
    }

    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(Future<V> future, Function<Exception, X> function) {
        return new MappingCheckedFuture<V, X>(Futures.makeListenable(future), function);
    }

    public static <V> ListenableFuture<V> immediateFuture(@Nullable V v) {
        ValueFuture<V> valueFuture = ValueFuture.create();
        valueFuture.set(v);
        return valueFuture;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V v) {
        ValueFuture<V> valueFuture = ValueFuture.create();
        valueFuture.set(v);
        return Futures.makeChecked(valueFuture, new Function<Exception, X>(){

            @Override
            public X apply(Exception exception) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        ValueFuture valueFuture = ValueFuture.create();
        valueFuture.setException(throwable);
        return valueFuture;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(final X x) {
        Preconditions.checkNotNull(x);
        return Futures.makeChecked(Futures.immediateFailedFuture(x), new Function<Exception, X>(){

            @Override
            public X apply(Exception exception) {
                return x;
            }
        });
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> listenableFuture, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(listenableFuture, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> listenableFuture, Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor executor) {
        ChainingListenableFuture chainingListenableFuture = new ChainingListenableFuture(function, listenableFuture);
        listenableFuture.addListener(chainingListenableFuture, executor);
        return chainingListenableFuture;
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function) {
        return Futures.compose(listenableFuture, function, MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> compose(ListenableFuture<I> listenableFuture, final Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        Function function2 = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I i) {
                Object t = function.apply(i);
                return Futures.immediateFuture(t);
            }
        };
        return Futures.chain(listenableFuture, function2, executor);
    }

    public static <I, O> Future<O> compose(final Future<I> future, final Function<? super I, ? extends O> function) {
        if (future instanceof ListenableFuture) {
            return Futures.compose((ListenableFuture)future, function);
        }
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){
            private final Object lock = new Object();
            private boolean set = false;
            private O value = null;
            private ExecutionException exception = null;

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.apply(future.get());
            }

            @Override
            public O get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.apply(future.get(l, timeUnit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private O apply(I i) throws ExecutionException {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.set) {
                        try {
                            this.value = function.apply(i);
                        }
                        catch (RuntimeException runtimeException) {
                            this.exception = new ExecutionException(runtimeException);
                        }
                        catch (Error error) {
                            this.exception = new ExecutionException(error);
                        }
                        this.set = true;
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    return this.value;
                }
            }

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractListenableFuture<O>
    implements Runnable {
        private Function<? super I, ? extends ListenableFuture<? extends O>> function;
        private ListenableFuture<? extends I> inputFuture;
        private volatile ListenableFuture<? extends O> outputFuture;
        private final BlockingQueue<Boolean> mayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
        private final CountDownLatch outputCreated = new CountDownLatch(1);

        private ChainingListenableFuture(Function<? super I, ? extends ListenableFuture<? extends O>> function, ListenableFuture<? extends I> listenableFuture) {
            this.function = Preconditions.checkNotNull(function);
            this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            if (!this.isDone()) {
                ListenableFuture<I> listenableFuture = this.inputFuture;
                if (listenableFuture != null) {
                    listenableFuture.get();
                }
                this.outputCreated.await();
                ListenableFuture<O> listenableFuture2 = this.outputFuture;
                if (listenableFuture2 != null) {
                    listenableFuture2.get();
                }
            }
            return (O)super.get();
        }

        @Override
        public O get(long l, TimeUnit timeUnit) throws TimeoutException, ExecutionException, InterruptedException {
            if (!this.isDone()) {
                long l2;
                ListenableFuture<I> listenableFuture;
                if (timeUnit != TimeUnit.NANOSECONDS) {
                    l = TimeUnit.NANOSECONDS.convert(l, timeUnit);
                    timeUnit = TimeUnit.NANOSECONDS;
                }
                if ((listenableFuture = this.inputFuture) != null) {
                    l2 = System.nanoTime();
                    listenableFuture.get(l, timeUnit);
                    l -= Math.max(0L, System.nanoTime() - l2);
                }
                l2 = System.nanoTime();
                if (!this.outputCreated.await(l, timeUnit)) {
                    throw new TimeoutException();
                }
                l -= Math.max(0L, System.nanoTime() - l2);
                ListenableFuture<O> listenableFuture2 = this.outputFuture;
                if (listenableFuture2 != null) {
                    listenableFuture2.get(l, timeUnit);
                }
            }
            return (O)super.get(l, timeUnit);
        }

        @Override
        public boolean cancel(boolean bl) {
            if (this.cancel()) {
                try {
                    this.mayInterruptIfRunningChannel.put(bl);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.cancel(this.inputFuture, bl);
                this.cancel(this.outputFuture, bl);
                return true;
            }
            return false;
        }

        private void cancel(@Nullable Future<?> future, boolean bl) {
            if (future != null) {
                future.cancel(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block18: {
                try {
                    I i;
                    try {
                        i = Futures.makeUninterruptible(this.inputFuture).get();
                    }
                    catch (CancellationException cancellationException) {
                        this.cancel();
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    catch (ExecutionException executionException) {
                        this.setException(executionException.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    this.outputFuture = this.function.apply(i);
                    final ListenableFuture<O> listenableFuture = this.outputFuture;
                    if (this.isCancelled()) {
                        try {
                            listenableFuture.cancel(this.mayInterruptIfRunningChannel.take());
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        this.outputFuture = null;
                        return;
                    }
                    listenableFuture.addListener(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ChainingListenableFuture.this.set(Futures.makeUninterruptible(listenableFuture).get());
                            }
                            catch (CancellationException cancellationException) {
                                ChainingListenableFuture.this.cancel();
                                return;
                            }
                            catch (ExecutionException executionException) {
                                ChainingListenableFuture.this.setException(executionException.getCause());
                            }
                            finally {
                                ChainingListenableFuture.this.outputFuture = null;
                            }
                        }
                    }, MoreExecutors.sameThreadExecutor());
                    break block18;
                    {
                        catch (UndeclaredThrowableException undeclaredThrowableException) {
                            this.setException(undeclaredThrowableException.getCause());
                            break block18;
                        }
                        catch (RuntimeException runtimeException) {
                            this.setException(runtimeException);
                            break block18;
                        }
                        catch (Error error) {
                            this.setException(error);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenableFutureAdapter<V>
    extends ForwardingFuture<V>
    implements ListenableFuture<V> {
        private static final Executor adapterExecutor = Executors.newCachedThreadPool();
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<V> delegate;

        ListenableFutureAdapter(Future<V> future) {
            this.delegate = Preconditions.checkNotNull(future);
        }

        @Override
        protected Future<V> delegate() {
            return this.delegate;
        }

        @Override
        public void addListener(Runnable runnable, Executor executor) {
            if (!this.hasListeners.get() && this.hasListeners.compareAndSet(false, true)) {
                adapterExecutor.execute(new Runnable(){

                    public void run() {
                        try {
                            ListenableFutureAdapter.this.delegate.get();
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (InterruptedException interruptedException) {
                            throw new IllegalStateException("Adapter thread interrupted!", interruptedException);
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        ListenableFutureAdapter.this.executionList.run();
                    }
                });
            }
            this.executionList.add(runnable, executor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> listenableFuture, Function<Exception, X> function) {
            super(listenableFuture);
            this.mapper = Preconditions.checkNotNull(function);
        }

        @Override
        protected X mapException(Exception exception) {
            return (X)((Exception)this.mapper.apply(exception));
        }
    }
}

